#!/bin/bash
#!/bin/bash
# Author: Christophe Casalegno / Brain 0verride
# Contact: brain@christophe-casalegno.com
# Version 0.1
#
# Copyright (c) 2020 Christophe Casalegno
# 
# This program is free software: you can redistribute it and/or modify
#
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <https://www.gnu.org/licenses/>
#
# The license is available on this server here: 
# https://www.christophe-casalegno.com/licences/gpl-3.0.txt

workplace="/home/sxadmin/log"
blacklistipv4="$workplace/blacklistipv4.txt"
blacklistipv6="$workplace/blacklistipv6.txt"
whitelist=("0.0.0.0" "0.0.0.0/0" "1.1.1.1" "8.8.8.8")
target2unblacklist="$1"

function check_whitelist()
{
for ip in "${whitelist[@]}"
do
	if [ "$target2unblacklist" == "$ip" ]
	then
		echo "$target2unblacklist can't be removed from firewall rules policy"
		exit 1
	fi
done
}

function address_type()
{
	local ipv4_regex="^(([01]{,1}[0-9]{1,2}|2[0-4][0-9]|25[0-5])\.){3}([01]{,1}[0-9]{1,2}|2[0-4][0-9]|25[0-5])$"
	local ipv4_network_regex="^(((25[0-5]|2[0-4][0-9]|1?[0-9][0-9]?)\.){3}(25[0-5]|2[0-4][0-9]|1?[0-9][0-9]?))(\/([8-9]|[1-2][0-9]|3[0-2]))$"
	local ipv6_regex="^([0-9a-fA-F]{1,4}(:[0-9a-fA-F]{1,4})*)?::([0-9a-fA-F]{1,4}(:[0-9a-fA-F]{1,4})*)?$"
	local ipv6_network_regex="^([0-9a-fA-F]{1,4}:){1,7}([0-9a-fA-F]{1,4}|:)(/[0-9]{1,3})?$"
	local hostname_regex="^(?=^.{4,253}\.?$)(^((?!-)[a-zA-Z0-9-]{1,63}(?<!-)\.)+[a-zA-Z]{2,63}\.?$)"

	if [[ $target2unblacklist =~ $ipv4_regex ]] || [[ $target2unblacklist =~ $ipv4_network_regex ]] || [[ $target2unblacklist =~ $hostname_regex ]]
	then
		address_type="ipv4"
	elif [[ $target2unblacklist =~ $ipv6_regex ]] || [[ $target2unblacklist =~ $ipv6_network_regex ]] 
	then
		address_type="ipv6"
	else
		echo "ERROR: Invalid format. Not an IPv4, IPv6, network or a valid hostname."
		exit 1
	fi
}

function unblacklist_target()
{
if [ "$address_type" == "ipv4" ]
then
	while iptables -C INPUT -s "$target2unblacklist" -j DROP 2> /dev/null  
	do
		iptables -D INPUT -s "$target2unblacklist" -j DROP -v
	done

	sed -i "\#${target2unblacklist}#d" "$blacklistipv4"

elif [ "$address_type" == "ipv6" ]
then
	while ip6tables -C INPUT -s "$target2unblacklist" -j DROP 2> /dev/null
	do
		ip6tables -D INPUT -s "$target2unblacklist" -j DROP -v
	done
	sed -i "\#${target2unblacklist}#d" "$blacklistipv6"
fi

}

check_whitelist
address_type
unblacklist_target

